//=============================================================================
// GreaselSpit.
//=============================================================================
class AcidGlob extends DeusExProjectile;

#exec OBJ LOAD FILE=Effects

simulated function Tick(float DeltaTime)
{
	local SmokeTrail s;

	Super.Tick(DeltaTime);

	time += DeltaTime;
	if ((time > FRand() * 0.02) && (Level.NetMode != NM_DedicatedServer))
	{
		time = 0;

		// spawn some trails
		s = Spawn(class'SmokeTrail',,, Location);
		if (s != None)
		{
			s.DrawScale = FRand() * 0.05;
			s.OrigScale = s.DrawScale;
			s.Texture = Texture'Effects.Smoke.Gas_Poison_A';
			s.Velocity = VRand() * 50;
			s.OrigVel = s.Velocity;
		}
	}
}




auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (bStuck)
			return;

		if ((Other != instigator) && (DeusExProjectile(Other) == None) &&
			(Other != Owner))
		{
			damagee = Other;
			Explode(HitLocation, Normal(HitLocation-damagee.Location));

         // DEUS_EX AMSD Spawn blood server side only
         if (Role == ROLE_Authority)
			{
            if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && bBlood)
               SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));

			ApplyAcid(Other);
			}
		}
	}
}


function ApplyAcid(Actor A)
{
 local AcidMold M;
 
 M = spawn(class'AcidMold',Owner,,A.Location);
 M.Moldee = A;
}

defaultproperties
{
     DamageType=Acid
     AccurateRange=300
     maxRange=450
     bIgnoresNanoDefense=True
     speed=600.000000
     MaxSpeed=800.000000
     Damage=10.000000
     MomentumTransfer=400
     DrawScale=1.500000
     SpawnSound=Sound'DeusExSounds.Animal.GreaselShoot'
     Style=STY_Translucent
     ImpactSound=None
     bStickToWall=False
     Mesh=LodMesh'DeusExItems.GreaselSpit'
}
